/*  Neugenerierung aller möglichen Knoten und Pfade der Arbeitsgänge einer ABK.

    Ein Knoten (vertex) ist der Arbeitsplatz (ksvba) auf dem ein Arbeitsgang (ab2) ausgeführt werden kann.
    Ein Pfad (edge) ist ein Übergang von welchem Arbeitsplatz zu welchem Arbeitsplatz produziert werden kann.
*/
SELECT tsystem.function__drop_by_regex( 'vertex__generate_path', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.vertex__generate_path(
    _abk_ix       int,
    _start_ab2_id int = null,
    _end_ab2_id   int = null,
    _loglevel     int DEFAULT TSystem.Log_Get_LogLevel( _user => 'yes' )
) RETURNS void AS $$
    DECLARE
        _ab2_a2_n_range int[];
        _ab2__resource_requirements_options__ksvba__from__ab2__create bool = false;
    BEGIN

        _ab2_a2_n_range := scheduling.abk__ab2__range_number__get( _abk_ix, _start_ab2_id, _end_ab2_id, true );

        -- prepare vertcies; maybe this should be refactored into a trigger to persist date
        -- this cascades to scheduling.edge
        DELETE FROM scheduling.vertex
        WHERE ab2_a2_id IN (
            SELECT a2_id
            FROM ab2
            WHERE a2_ab_ix = _abk_ix
        );

        <<_recheck_after__resource_requirements_option_creation>>
        LOOP -- nur pseudo wegen Sprungmarke
            -- recreate vertices and edge for a given abk
            INSERT INTO scheduling.vertex ( ab2_a2_id, resource_id                                                             , load )
            SELECT                          ab2.a2_id, coalesce( rro.resource_id, a2w.a2w_resource_id_main_fix ) AS resource_id, coalesce( rro.load, 1 ) AS load  -- Coalesce auf a2w_resource_id_main_fix, weil verschobene AGs zwar richtig auf einer Resource liegen, aber keine ResourcenOption für diese eingetragen wird, wenn nicht zu den möglichen KSVBAs gehört.
              FROM ab2
              JOIN ab2_wkstplan a2w ON a2w.a2w_a2_id = ab2.a2_id AND NOT a2w_marked = -1 -- SplitAGs;
              JOIN ksv ON ks_abt = coalesce(a2w_resource_ks_abt_main_fix, a2_ks)
              JOIN scheduling.resource r                                    ON r.context_id = a2_id  AND r.context = 'ab2'
              JOIN scheduling.resource_requirement rr                       ON rr.required_by = r.id AND rr.context = 'ksvba'
              LEFT JOIN scheduling.resource_requirement_option rro          ON rro.requirement_id = rr.id AND rro.resource_id = coalesce( a2w.a2w_resource_id_main_fix, rro.resource_id )
            WHERE ab2.a2_ab_ix = _abk_ix
              AND coalesce( a2w.a2w_resource_id_main_fix, rro.resource_id ) IS NOT null
              AND NOT a2_ende -- scheduling.ab2__is_terminateable( ab2 )
              AND ks_plan
              AND ab2.a2_n >= _ab2_a2_n_range[1]
              AND ab2.a2_n <= _ab2_a2_n_range[2]
            ;

            -- ACHTUNG LOAD knallt mit null, wenn "ab2__resource_requirement_options__add_option" fehlt und wir in ab2_wkstplan eine resource_id haben, welche nicht als option angelegt wurde. Ursache noch unklar.

            IF NOT FOUND THEN
                IF NOT _ab2__resource_requirements_options__ksvba__from__ab2__create THEN
                    _ab2__resource_requirements_options__ksvba__from__ab2__create := true;
                    -- Falls nicht Warnung ausgeben und dann die Ressourcenoptionen für die ABK generieren.
                    RAISE WARNING 'vertex__generate_path : no resource_requirement_option found, calling "ab2__resource_requirements_options__ksvba__from__ab2__create"';
        PERFORM scheduling.ab2__resource_requirements_options__ksvba__from__ab2__create( ab2, _loglevel => _loglevel )
                       FROM ab2
                      WHERE a2_ab_ix = _abk_ix
                        AND ab2.a2_n >= _ab2_a2_n_range[1]
                        AND ab2.a2_n <= _ab2_a2_n_range[2]
                    ;
                    CONTINUE _recheck_after__resource_requirements_option_creation;
                ELSE
                    RAISE EXCEPTION 'vertex__generate_path:ABK:% : no resource_requirement_option found AFTER "ab2__resource_requirements_options__ksvba__from__ab2__create". ab2__resource_requirement_options__add_option?!', _abk_ix;
                END IF;
            END IF;

            EXIT;
        END LOOP;

        INSERT INTO scheduling.edge ( vertex_from, vertex_to )
        WITH
          _vertex AS (
              SELECT
                array_agg( id ) AS _source,
                lag( array_agg( id ) ) OVER( partition by a2_ab_ix ORDER BY a2_n DESC ) AS _dest
              FROM scheduling.vertex
              JOIN ab2 on ab2_a2_id = a2_id
              WHERE ab2.a2_ab_ix = _abk_ix
              GROUP BY a2_id
              ORDER BY a2_n ASC
          ),
          _v AS (
              -- unpacking source
              SELECT unnest( _source ) _source, _dest
              FROM _vertex v1
              WHERE _dest IS NOT NULL
          )
          -- unpacking destination
          SELECT _source, unnest( _dest ) _dest
          FROM _v;

        RETURN;

    END $$ LANGUAGE plpgsql;
    --